# TrungDuongService Backend API

> Laravel 11 RESTful API for Inventory & Debt Management System

## 📋 Table of Contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Database Setup](#database-setup)
- [Running the Application](#running-the-application)
- [API Documentation](#api-documentation)
- [Testing](#testing)
- [Deployment](#deployment)

## 🔧 Requirements

- PHP >= 8.2
- Composer
- MySQL >= 8.0 or MariaDB >= 10.3
- Node.js >= 18.x (for assets)
- Redis (optional, for queues and cache)

## 📦 Installation

### 1. Clone & Install Dependencies

```bash
cd backend
composer install
npm install
```

### 2. Environment Configuration

```bash
cp .env.example .env
php artisan key:generate
```

### 3. Configure Database

Edit `.env` file:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=trungduongservice
DB_USERNAME=root
DB_PASSWORD=your_password
```

### 4. Run Migrations & Seed Data

```bash
php artisan migrate --seed
```

This will create:
- All database tables (20 tables)
- Admin user: `admin@trungduong.com` / `admin123`
- Demo data (products, customers, orders)

## ⚙️ Configuration

### Mail Configuration

```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-email@gmail.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@trungduong.com
MAIL_FROM_NAME="TrungDuong Service"
```

### Queue Configuration

For production, use Redis or database:

```env
QUEUE_CONNECTION=redis
# or
QUEUE_CONNECTION=database
```

Run queue worker:

```bash
php artisan queue:work
```

### Task Scheduling

Add to crontab:

```bash
* * * * * cd /path-to-project/backend && php artisan schedule:run >> /dev/null 2>&1
```

Scheduled tasks:
- **Daily at 9:00 AM**: Check low stock & send notifications
- **Every Monday at 10:00 AM**: Send debt reminders
- **Daily at midnight**: Generate daily reports

## 🗄️ Database Setup

### Manual Setup

```bash
# Create database
mysql -u root -p
CREATE DATABASE trungduongservice CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
exit;

# Run migrations
php artisan migrate

# Seed demo data
php artisan db:seed
```

### Fresh Install

```bash
php artisan migrate:fresh --seed
```

**Warning**: This will drop all tables and recreate them!

## 🚀 Running the Application

### Development Server

```bash
php artisan serve
```

API will be available at: `http://localhost:8000`

### Build Assets

```bash
npm run dev
# or for production
npm run build
```

### Queue Worker

```bash
php artisan queue:work --tries=3
```

## 📚 API Documentation

### Base URL

```
http://localhost:8000/api
```

### Authentication

All API requests require Bearer token:

```bash
# Login
POST /api/login
{
  "email": "admin@trungduong.com",
  "password": "admin123"
}

# Response
{
  "access_token": "1|xxxxx",
  "token_type": "Bearer",
  "user": {...}
}

# Use token in headers
Authorization: Bearer 1|xxxxx
```

### Main Endpoints

#### Products
- `GET /api/products` - List all products
- `POST /api/products` - Create product
- `GET /api/products/{id}` - Get product details
- `PUT /api/products/{id}` - Update product
- `DELETE /api/products/{id}` - Delete product

#### Sales Orders
- `GET /api/sales-orders` - List orders
- `POST /api/sales-orders` - Create order
- `GET /api/sales-orders/{id}` - Order details
- `PUT /api/sales-orders/{id}` - Update order
- `DELETE /api/sales-orders/{id}` - Cancel order

#### Customers
- `GET /api/customers` - List customers
- `POST /api/customers` - Create customer
- `GET /api/customers/{id}` - Customer details
- `PUT /api/customers/{id}` - Update customer
- `DELETE /api/customers/{id}` - Delete customer

#### Reports
- `GET /api/reports/sales?start_date=2024-01-01&end_date=2024-12-31`
- `GET /api/reports/profit?start_date=2024-01-01&end_date=2024-12-31`
- `GET /api/reports/inventory`

See [API-DOCUMENTATION.md](../API-DOCUMENTATION.md) for complete API reference.

## 🧪 Testing

### Run All Tests

```bash
php artisan test
```

### Run Specific Test Suite

```bash
# Feature tests
php artisan test --testsuite=Feature

# Unit tests
php artisan test --testsuite=Unit

# Specific test file
php artisan test tests/Feature/ProductTest.php
```

### Test Coverage

```bash
php artisan test --coverage
```

## 🔐 Security

### Generate App Key

```bash
php artisan key:generate
```

### Clear Config Cache

```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

### Optimize for Production

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
composer install --optimize-autoloader --no-dev
```

## 📦 Deployment

### Deployment Checklist

1. Set `APP_ENV=production` in `.env`
2. Set `APP_DEBUG=false`
3. Run `composer install --optimize-autoloader --no-dev`
4. Run `php artisan config:cache`
5. Run `php artisan route:cache`
6. Run `php artisan view:cache`
7. Set proper file permissions:
   ```bash
   chmod -R 775 storage bootstrap/cache
   chown -R www-data:www-data storage bootstrap/cache
   ```
8. Setup queue worker with Supervisor
9. Setup cron job for scheduler

### Supervisor Configuration

```ini
[program:trungduongservice-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /path/to/backend/artisan queue:work --sleep=3 --tries=3 --max-time=3600
autostart=true
autorestart=true
stopasgroup=true
killasgroup=true
user=www-data
numprocs=2
redirect_stderr=true
stdout_logfile=/path/to/backend/storage/logs/worker.log
stopwaitsecs=3600
```

## 🛠️ Artisan Commands

### Custom Commands

```bash
# Check low stock products
php artisan stock:check-low

# Check and send notifications
php artisan stock:check-low --notify

# Send debt reminders
php artisan debt:send-reminders

# Generate daily report
php artisan report:generate-daily

# Generate report for specific date
php artisan report:generate-daily --date=2024-11-28
```

### Database Commands

```bash
# Fresh migration with seed
php artisan migrate:fresh --seed

# Rollback last migration
php artisan migrate:rollback

# Reset all migrations
php artisan migrate:reset
```

## 📝 Code Structure

```
app/
├── Console/Commands/      # Artisan commands
├── Contracts/             # Interfaces
├── Enums/                 # Enumerations
├── Events/                # Domain events
├── Exceptions/            # Custom exceptions
├── Helpers/               # Helper functions
├── Http/
│   ├── Controllers/Api/   # API controllers
│   ├── Middleware/        # Custom middleware
│   ├── Requests/          # Form request validation
│   └── Resources/         # API resources
├── Jobs/                  # Queue jobs
├── Listeners/             # Event listeners
├── Models/                # Eloquent models
├── Notifications/         # Notifications
├── Observers/             # Model observers
├── Policies/              # Authorization policies
├── Providers/             # Service providers
├── Repositories/          # Data repositories
├── Rules/                 # Validation rules
├── Services/              # Business logic
└── Traits/                # Reusable traits
```

## 🤝 Contributing

1. Fork the repository
2. Create feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to branch (`git push origin feature/AmazingFeature`)
5. Open Pull Request

## 📄 License

This project is proprietary software for TrungDuong Service.

## 👥 Support

For support, email: support@trungduong.com

## 🔄 Version History

- **v3.0.0** (2024-11-29) - Complete Enterprise Edition
  - Added Observers, Services, Repositories
  - Added Console Commands
  - Added Contracts/Interfaces
  - Complete test coverage
  
- **v2.0.0** (2024-11-28) - Enhanced Edition
  - Added Form Requests
  - Added API Resources
  - Added Events & Listeners
  
- **v1.0.0** (2024-11-28) - Initial Release
  - Core CRUD functionality
  - Basic API endpoints
  - Authentication system
