<?php

namespace App\Console\Commands;

use App\Models\Customer;
use App\Notifications\DebtReminder;
use Illuminate\Console\Command;

class SendDebtRemindersCommand extends Command
{
    protected $signature = 'debt:send-reminders
                          {--days=7 : Number of days overdue}';

    protected $description = 'Send debt reminder notifications to customers';

    public function handle(): int
    {
        $this->info('Sending debt reminders...');

        $customers = Customer::whereHas('debts', function ($query) {
            $query->where('status', 'unpaid')
                  ->where('due_date', '<', now());
        })->with(['debts' => function ($query) {
            $query->where('status', 'unpaid');
        }])->get();

        $count = 0;
        foreach ($customers as $customer) {
            $totalDebt = $customer->debts->sum(function ($debt) {
                return $debt->amount - $debt->paid_amount;
            });

            if ($totalDebt > 0 && $customer->email) {
                $customer->notify(new DebtReminder($customer->name, $totalDebt));
                $count++;
            }
        }

        $this->info("Sent {$count} debt reminder(s).");

        return Command::SUCCESS;
    }
}
