<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Check low stock daily at 9 AM
        $schedule->command('stock:check-low --notify')->dailyAt('09:00');
        
        // Send debt reminders every Monday at 10 AM
        $schedule->command('debt:send-reminders')->weeklyOn(1, '10:00');
        
        // Generate daily report at midnight
        $schedule->command('report:generate-daily')->daily();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
