<?php

namespace App\Contracts\Repositories;

use Illuminate\Support\Collection;

interface OrderRepositoryInterface extends RepositoryInterface
{
    /**
     * Get orders by customer
     */
    public function getByCustomer(int $customerId): Collection;

    /**
     * Get orders by date range
     */
    public function getByDateRange(string $startDate, string $endDate): Collection;

    /**
     * Get orders by status
     */
    public function getByStatus(string $status): Collection;

    /**
     * Get total revenue for date range
     */
    public function getTotalRevenue(string $startDate, string $endDate): float;

    /**
     * Get unpaid orders
     */
    public function getUnpaidOrders(): Collection;
}
