<?php

namespace App\Contracts\Repositories;

use App\Models\Product;
use Illuminate\Support\Collection;

interface ProductRepositoryInterface extends RepositoryInterface
{
    /**
     * Search products by keyword
     */
    public function search(string $keyword): Collection;

    /**
     * Get products by category
     */
    public function getByCategory(int $categoryId): Collection;

    /**
     * Get products by brand
     */
    public function getByBrand(int $brandId): Collection;

    /**
     * Get low stock products
     */
    public function getLowStock(): Collection;

    /**
     * Get out of stock products
     */
    public function getOutOfStock(): Collection;

    /**
     * Find product by SKU
     */
    public function getBySku(string $sku): ?Product;
}
