<?php

namespace App\Contracts\Services;

use App\Models\Inventory;

interface InventoryServiceInterface
{
    /**
     * Add stock to inventory
     */
    public function add(int $productId, int $warehouseId, int $quantity): Inventory;

    /**
     * Deduct stock from inventory
     */
    public function deduct(int $productId, int $warehouseId, int $quantity): Inventory;

    /**
     * Transfer stock between warehouses
     */
    public function transfer(
        int $productId,
        int $fromWarehouseId,
        int $toWarehouseId,
        int $quantity
    ): bool;

    /**
     * Get available stock for a product
     */
    public function getAvailableStock(int $productId, ?int $warehouseId = null): int;
}
