<?php

namespace App\Contracts\Services;

use App\Models\SalesOrder;

interface OrderServiceInterface
{
    /**
     * Create a new sales order
     */
    public function createSalesOrder(array $data): SalesOrder;

    /**
     * Cancel a sales order
     */
    public function cancelSalesOrder(int $orderId): bool;

    /**
     * Calculate profit for an order
     */
    public function calculateProfit(SalesOrder $order): float;
}
