<?php

namespace App\Enums;

enum PaymentMethod: string
{
    case CASH = 'cash';
    case TRANSFER = 'transfer';
    case CARD = 'card';

    public function label(): string
    {
        return match($this) {
            self::CASH => 'Tiền mặt',
            self::TRANSFER => 'Chuyển khoản',
            self::CARD => 'Thẻ',
        };
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}
