<?php

namespace App\Enums;

enum UserRole: string
{
    case ADMIN = 'admin';
    case MANAGER = 'manager';
    case STAFF = 'staff';

    public function label(): string
    {
        return match($this) {
            self::ADMIN => 'Quản trị viên',
            self::MANAGER => 'Quản lý',
            self::STAFF => 'Nhân viên',
        };
    }

    public function permissions(): array
    {
        return match($this) {
            self::ADMIN => ['*'], // Full access
            self::MANAGER => [
                'products.create',
                'products.update',
                'orders.create',
                'orders.view',
                'reports.view',
            ],
            self::STAFF => [
                'orders.create',
                'orders.view',
                'products.view',
            ],
        };
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}
