<?php

if (!function_exists('format_currency')) {
    function format_currency(float $amount): string
    {
        return number_format($amount, 0, ',', '.') . ' đ';
    }
}

if (!function_exists('format_date')) {
    function format_date($date): string
    {
        return \Carbon\Carbon::parse($date)->format('d/m/Y');
    }
}

if (!function_exists('format_datetime')) {
    function format_datetime($date): string
    {
        return \Carbon\Carbon::parse($date)->format('d/m/Y H:i');
    }
}

if (!function_exists('generate_order_number')) {
    function generate_order_number(string $prefix): string
    {
        return $prefix . '-' . date('Ymd') . '-' . strtoupper(uniqid());
    }
}

if (!function_exists('calculate_profit_margin')) {
    function calculate_profit_margin(float $revenue, float $cost): float
    {
        if ($revenue <= 0) {
            return 0;
        }
        return (($revenue - $cost) / $revenue) * 100;
    }
}

if (!function_exists('check_permission')) {
    function check_permission(string $permission): bool
    {
        if (!auth()->check()) {
            return false;
        }

        $user = auth()->user();
        
        if ($user->role === 'admin') {
            return true;
        }

        $role = \App\Enums\UserRole::from($user->role);
        $permissions = $role->permissions();

        return in_array('*', $permissions) || in_array($permission, $permissions);
    }
}
