<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    public function index()
    {
        $brands = Brand::withCount('products')
                       ->orderBy('name')
                       ->get();

        return response()->json($brands);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:brands,name',
            'description' => 'nullable|string',
        ]);

        $brand = Brand::create($request->all());

        return response()->json([
            'message' => 'Thêm thương hiệu thành công',
            'brand' => $brand
        ], 201);
    }

    public function show($id)
    {
        $brand = Brand::with('products')->findOrFail($id);

        return response()->json($brand);
    }

    public function update(Request $request, $id)
    {
        $brand = Brand::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255|unique:brands,name,' . $id,
            'description' => 'nullable|string',
        ]);

        $brand->update($request->all());

        return response()->json([
            'message' => 'Cập nhật thương hiệu thành công',
            'brand' => $brand
        ]);
    }

    public function destroy($id)
    {
        $brand = Brand::findOrFail($id);

        if ($brand->products()->count() > 0) {
            return response()->json([
                'message' => 'Không thể xóa thương hiệu có sản phẩm'
            ], 422);
        }

        $brand->delete();

        return response()->json([
            'message' => 'Xóa thương hiệu thành công'
        ]);
    }
}
