<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Unit;
use Illuminate\Http\Request;

class UnitController extends Controller
{
    public function index()
    {
        $units = Unit::withCount('products')
                    ->orderBy('name')
                    ->get();

        return response()->json($units);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'short_name' => 'required|string|max:20',
        ]);

        $unit = Unit::create($request->all());

        return response()->json([
            'message' => 'Thêm đơn vị tính thành công',
            'unit' => $unit
        ], 201);
    }

    public function show($id)
    {
        $unit = Unit::with('products')->findOrFail($id);

        return response()->json($unit);
    }

    public function update(Request $request, $id)
    {
        $unit = Unit::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255',
            'short_name' => 'required|string|max:20',
        ]);

        $unit->update($request->all());

        return response()->json([
            'message' => 'Cập nhật đơn vị tính thành công',
            'unit' => $unit
        ]);
    }

    public function destroy($id)
    {
        $unit = Unit::findOrFail($id);

        if ($unit->products()->count() > 0) {
            return response()->json([
                'message' => 'Không thể xóa đơn vị tính có sản phẩm'
            ], 422);
        }

        $unit->delete();

        return response()->json([
            'message' => 'Xóa đơn vị tính thành công'
        ]);
    }
}
