<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Warehouse;
use Illuminate\Http\Request;

class WarehouseController extends Controller
{
    public function index()
    {
        $warehouses = Warehouse::with(['manager', 'inventory.product'])
                               ->withCount('inventory')
                               ->orderBy('name')
                               ->get();

        return response()->json($warehouses);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'nullable|string',
            'phone' => 'nullable|string|max:20',
            'manager_id' => 'nullable|exists:users,id',
        ]);

        $warehouse = Warehouse::create($request->all());

        return response()->json([
            'message' => 'Thêm kho thành công',
            'warehouse' => $warehouse->load('manager')
        ], 201);
    }

    public function show($id)
    {
        $warehouse = Warehouse::with(['manager', 'inventory.product'])
                              ->findOrFail($id);

        return response()->json($warehouse);
    }

    public function update(Request $request, $id)
    {
        $warehouse = Warehouse::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'nullable|string',
            'phone' => 'nullable|string|max:20',
            'manager_id' => 'nullable|exists:users,id',
        ]);

        $warehouse->update($request->all());

        return response()->json([
            'message' => 'Cập nhật kho thành công',
            'warehouse' => $warehouse->load('manager')
        ]);
    }

    public function destroy($id)
    {
        $warehouse = Warehouse::findOrFail($id);

        if ($warehouse->inventory()->count() > 0) {
            return response()->json([
                'message' => 'Không thể xóa kho có hàng tồn'
            ], 422);
        }

        $warehouse->delete();

        return response()->json([
            'message' => 'Xóa kho thành công'
        ]);
    }
}
