<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PayDebtRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'debt_id' => 'required|exists:customer_debts,id',
            'amount' => 'required|numeric|min:1',
            'payment_method' => 'required|in:cash,transfer,card',
            'notes' => 'nullable|string|max:500',
        ];
    }

    public function messages(): array
    {
        return [
            'debt_id.required' => 'Phải chọn khoản nợ',
            'amount.required' => 'Số tiền thanh toán không được để trống',
            'amount.min' => 'Số tiền thanh toán phải lớn hơn 0',
            'payment_method.required' => 'Phương thức thanh toán không được để trống',
        ];
    }
}
