<?php

namespace App\Http\Requests;

use App\Rules\ValidPhone;
use Illuminate\Foundation\Http\FormRequest;

class StoreSupplierRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'phone' => ['required', 'string', 'unique:suppliers,phone', new ValidPhone()],
            'email' => 'nullable|email|unique:suppliers,email',
            'address' => 'nullable|string|max:500',
            'company_name' => 'nullable|string|max:255',
            'tax_code' => 'nullable|string|max:50',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'Tên nhà cung cấp không được để trống',
            'phone.required' => 'Số điện thoại không được để trống',
            'phone.unique' => 'Số điện thoại đã tồn tại',
        ];
    }
}
