<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SupplierResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'phone' => $this->phone,
            'email' => $this->email,
            'address' => $this->address,
            'company_name' => $this->company_name,
            'tax_code' => $this->tax_code,
            'total_debt' => $this->when(isset($this->total_debt), $this->total_debt),
            'created_at' => $this->created_at?->format('Y-m-d H:i:s'),
        ];
    }
}
