<?php

namespace App\Jobs;

use App\Models\Product;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class ProcessLowStockAlert implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $product;

    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    public function handle(): void
    {
        $totalStock = $this->product->inventory()->sum('quantity');
        
        if ($totalStock <= $this->product->min_stock) {
            Log::warning('Low stock alert', [
                'product_id' => $this->product->id,
                'product_name' => $this->product->name,
                'current_stock' => $totalStock,
                'min_stock' => $this->product->min_stock,
            ]);
            
            // TODO: Send notification to admin
            // event(new LowStockDetected($this->product, $totalStock));
        }
    }
}
