<?php

namespace App\Jobs;

use App\Models\Customer;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SendDebtReminderJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $customer;
    protected $debtAmount;

    public function __construct(Customer $customer, float $debtAmount)
    {
        $this->customer = $customer;
        $this->debtAmount = $debtAmount;
    }

    public function handle(): void
    {
        Log::info('Debt reminder', [
            'customer_id' => $this->customer->id,
            'customer_name' => $this->customer->name,
            'debt_amount' => $this->debtAmount,
        ]);
        
        // TODO: Send SMS or Email reminder
        // Mail::to($this->customer->email)->send(new DebtReminder($this->customer, $this->debtAmount));
    }
}
