<?php

namespace App\Listeners;

use App\Events\LowStockDetected;
use Illuminate\Support\Facades\Log;

class SendLowStockNotification
{
    public function handle(LowStockDetected $event): void
    {
        Log::warning('Low Stock Alert', [
            'product' => $event->product->name,
            'current_stock' => $event->currentStock,
            'min_stock' => $event->product->min_stock,
        ]);
        
        // TODO: Send notification to admin via email/SMS
    }
}
