<?php

namespace App\Listeners;

use App\Events\SalesOrderCreated;
use App\Jobs\ProcessLowStockAlert;
use Illuminate\Contracts\Queue\ShouldQueue;

class UpdateInventoryAfterSale implements ShouldQueue
{
    public function handle(SalesOrderCreated $event): void
    {
        $salesOrder = $event->salesOrder;
        
        foreach ($salesOrder->items as $item) {
            // Check stock levels and dispatch low stock alert if needed
            $product = $item->product;
            $totalStock = $product->inventory()->sum('quantity');
            
            if ($totalStock <= $product->min_stock) {
                ProcessLowStockAlert::dispatch($product);
            }
        }
    }
}
