<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'phone',
        'email',
        'address',
        'total_debt',
        'is_active',
    ];

    protected $casts = [
        'total_debt' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function salesOrders()
    {
        return $this->hasMany(SalesOrder::class);
    }

    public function debts()
    {
        return $this->hasMany(CustomerDebt::class);
    }

    public function updateTotalDebt()
    {
        $this->total_debt = $this->debts()->where('status', '!=', 'paid')->sum('remaining_amount');
        $this->save();
    }
}
