<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_number',
        'customer_id',
        'warehouse_id',
        'user_id',
        'order_date',
        'subtotal',
        'discount',
        'total',
        'paid_amount',
        'payment_method',
        'status',
        'notes',
    ];

    protected $casts = [
        'order_date' => 'date',
        'subtotal' => 'decimal:2',
        'discount' => 'decimal:2',
        'total' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'payment_method' => \App\Enums\PaymentMethod::class,
        'status' => \App\Enums\OrderStatus::class,
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(SalesOrderItem::class);
    }

    public function debt()
    {
        return $this->hasOne(CustomerDebt::class);
    }

    public function getRemainingAmountAttribute()
    {
        return $this->total - $this->paid_amount;
    }

    public static function generateOrderNumber()
    {
        $prefix = 'SO';
        $date = now()->format('Ymd');
        $latest = self::whereDate('created_at', today())->count();
        $number = str_pad($latest + 1, 4, '0', STR_PAD_LEFT);
        return "{$prefix}{$date}{$number}";
    }
}
