<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DebtReminder extends Notification
{
    use Queueable;

    protected $debtAmount;
    protected $customerName;

    public function __construct(string $customerName, float $debtAmount)
    {
        $this->customerName = $customerName;
        $this->debtAmount = $debtAmount;
    }

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Nhắc nhở thanh toán công nợ')
            ->greeting("Kính gửi {$this->customerName},")
            ->line('Cảm ơn quý khách đã luôn tin tưởng và sử dụng dịch vụ của chúng tôi.')
            ->line("Hiện tại quý khách còn công nợ: " . number_format($this->debtAmount, 0, ',', '.') . ' VNĐ')
            ->line('Vui lòng thanh toán trong thời gian sớm nhất.')
            ->action('Xem chi tiết', url('/debts'));
    }
}
