<?php

namespace App\Notifications;

use App\Models\Product;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LowStockAlert extends Notification
{
    use Queueable;

    protected $product;
    protected $currentStock;

    public function __construct(Product $product, int $currentStock)
    {
        $this->product = $product;
        $this->currentStock = $currentStock;
    }

    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Cảnh báo: Hàng tồn kho thấp')
            ->line("Sản phẩm {$this->product->name} đang có số lượng tồn kho thấp.")
            ->line("Số lượng hiện tại: {$this->currentStock}")
            ->line("Số lượng tối thiểu: {$this->product->min_stock}")
            ->action('Xem chi tiết', url('/products/' . $this->product->id));
    }

    public function toArray(object $notifiable): array
    {
        return [
            'product_id' => $this->product->id,
            'product_name' => $this->product->name,
            'current_stock' => $this->currentStock,
            'min_stock' => $this->product->min_stock,
        ];
    }
}
