<?php

namespace App\Observers;

use App\Models\Product;
use Illuminate\Support\Str;

class ProductObserver
{
    public function creating(Product $product): void
    {
        // Auto-generate SKU if not provided
        if (empty($product->sku)) {
            $product->sku = 'PRD-' . strtoupper(Str::random(8));
        }
    }

    public function created(Product $product): void
    {
        \Log::info("Product created: {$product->name} (ID: {$product->id})");
    }

    public function updated(Product $product): void
    {
        if ($product->isDirty('cost_price') || $product->isDirty('selling_price')) {
            \Log::info("Product price updated: {$product->name}", [
                'old_cost' => $product->getOriginal('cost_price'),
                'new_cost' => $product->cost_price,
                'old_selling' => $product->getOriginal('selling_price'),
                'new_selling' => $product->selling_price,
            ]);
        }
    }

    public function deleting(Product $product): void
    {
        // Check if product has inventory
        if ($product->inventory()->exists()) {
            throw new \Exception('Cannot delete product with existing inventory');
        }
    }

    public function deleted(Product $product): void
    {
        \Log::warning("Product deleted: {$product->name} (ID: {$product->id})");
    }
}
