<?php

namespace App\Observers;

use App\Events\PurchaseOrderCreated;
use App\Models\PurchaseOrder;
use App\Models\SupplierDebt;

class PurchaseOrderObserver
{
    public function creating(PurchaseOrder $order): void
    {
        // Auto-generate order number
        if (empty($order->order_number)) {
            $order->order_number = 'PO-' . date('Ymd') . '-' . str_pad(
                PurchaseOrder::whereDate('created_at', today())->count() + 1,
                4,
                '0',
                STR_PAD_LEFT
            );
        }
    }

    public function created(PurchaseOrder $order): void
    {
        // Create debt if not fully paid
        $remainingAmount = $order->total - $order->paid_amount;
        
        if ($remainingAmount > 0) {
            SupplierDebt::create([
                'supplier_id' => $order->supplier_id,
                'purchase_order_id' => $order->id,
                'amount' => $remainingAmount,
                'paid_amount' => 0,
                'remaining_amount' => $remainingAmount,
                'due_date' => now()->addDays(30),
                'status' => 'unpaid',
            ]);
        }

        // Dispatch event
        event(new PurchaseOrderCreated($order));

        \Log::info("Purchase order created: {$order->order_number}");
    }
}
