<?php

namespace App\Policies;

use App\Models\SalesOrder;
use App\Models\User;

class SalesOrderPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, SalesOrder $salesOrder): bool
    {
        return true;
    }

    public function create(User $user): bool
    {
        return in_array($user->role, ['admin', 'manager', 'staff']);
    }

    public function update(User $user, SalesOrder $salesOrder): bool
    {
        if ($user->role === 'admin') {
            return true;
        }
        
        if ($salesOrder->user_id === $user->id && $salesOrder->status === 'pending') {
            return true;
        }
        
        return false;
    }

    public function delete(User $user, SalesOrder $salesOrder): bool
    {
        return $user->role === 'admin' && $salesOrder->status === 'pending';
    }
}
