<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register helpers
        require_once app_path('Helpers/helpers.php');
        
        // FIX BUG #2: Bind Repository Interfaces
        $this->app->bind(
            \App\Contracts\Repositories\RepositoryInterface::class,
            \App\Repositories\BaseRepository::class
        );
        
        $this->app->bind(
            \App\Contracts\Repositories\ProductRepositoryInterface::class,
            \App\Repositories\ProductRepository::class
        );
        
        $this->app->bind(
            \App\Contracts\Repositories\OrderRepositoryInterface::class,
            \App\Repositories\OrderRepository::class
        );
        
        // FIX BUG #2: Bind Service Interfaces
        $this->app->bind(
            \App\Contracts\Services\OrderServiceInterface::class,
            \App\Services\OrderService::class
        );
        
        $this->app->bind(
            \App\Contracts\Services\InventoryServiceInterface::class,
            \App\Services\InventoryService::class
        );
        
        $this->app->bind(
            \App\Contracts\Services\ReportServiceInterface::class,
            \App\Services\ReportService::class
        );
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register model observers
        \App\Models\Product::observe(\App\Observers\ProductObserver::class);
        \App\Models\SalesOrder::observe(\App\Observers\SalesOrderObserver::class);
        \App\Models\PurchaseOrder::observe(\App\Observers\PurchaseOrderObserver::class);
    }
}
