<?php

namespace App\Repositories;

use App\Models\SalesOrder;
use App\Contracts\Repositories\OrderRepositoryInterface;
use Illuminate\Support\Collection;

class OrderRepository extends BaseRepository implements OrderRepositoryInterface
{
    public function __construct(SalesOrder $model)
    {
        $this->model = $model;
    }

    public function getByCustomer(int $customerId): Collection
    {
        return $this->model
            ->where('customer_id', $customerId)
            ->with(['items.product', 'customer'])
            ->latest()
            ->get();
    }

    public function getByDateRange(string $startDate, string $endDate): Collection
    {
        return $this->model
            ->whereBetween('order_date', [$startDate, $endDate])
            ->with(['items.product', 'customer'])
            ->latest()
            ->get();
    }

    public function getByStatus(string $status): Collection
    {
        return $this->model
            ->where('status', $status)
            ->with(['items.product', 'customer'])
            ->latest()
            ->get();
    }

    public function getTotalRevenue(string $startDate, string $endDate): float
    {
        return $this->model
            ->whereBetween('order_date', [$startDate, $endDate])
            ->where('status', 'completed')
            ->sum('total');
    }

    public function getUnpaidOrders(): Collection
    {
        return $this->model
            ->whereRaw('total > paid_amount')
            ->with(['items.product', 'customer'])
            ->latest()
            ->get();
    }
}
