<?php

namespace App\Rules;

use App\Models\Product;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class SufficientStock implements ValidationRule
{
    protected $productId;
    protected $warehouseId;

    public function __construct($productId, $warehouseId)
    {
        $this->productId = $productId;
        $this->warehouseId = $warehouseId;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $product = Product::find($this->productId);
        
        if (!$product) {
            $fail('Sản phẩm không tồn tại');
            return;
        }
        
        $availableStock = $product->inventory()
            ->where('warehouse_id', $this->warehouseId)
            ->sum('quantity');
        
        if ($value > $availableStock) {
            $fail("Không đủ hàng trong kho. Số lượng khả dụng: {$availableStock}");
        }
    }
}
