<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidPhone implements ValidationRule
{
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // Vietnamese phone number validation
        // Format: 0xxxxxxxxx (10 digits) or +84xxxxxxxxx
        if (!preg_match('/^(0|\+84)[0-9]{9}$/', $value)) {
            $fail('Số điện thoại không hợp lệ. Định dạng: 0xxxxxxxxx hoặc +84xxxxxxxxx');
        }
    }
}
