<?php

namespace App\Traits;

use Illuminate\Support\Facades\Log;

trait LogsActivity
{
    protected static function bootLogsActivity(): void
    {
        static::created(function ($model) {
            Log::info(class_basename($model) . " created", [
                'id' => $model->id,
                'user_id' => auth()->id(),
            ]);
        });

        static::updated(function ($model) {
            Log::info(class_basename($model) . " updated", [
                'id' => $model->id,
                'user_id' => auth()->id(),
                'changes' => $model->getChanges(),
            ]);
        });

        static::deleted(function ($model) {
            Log::warning(class_basename($model) . " deleted", [
                'id' => $model->id,
                'user_id' => auth()->id(),
            ]);
        });
    }
}
