<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Unit;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductFactory extends Factory
{
    protected $model = Product::class;

    public function definition(): array
    {
        $costPrice = $this->faker->numberBetween(50000, 500000);
        $sellingPrice = $costPrice * $this->faker->randomFloat(2, 1.2, 2.0);

        return [
            'name' => $this->faker->words(3, true),
            'sku' => 'PRD-' . strtoupper($this->faker->unique()->bothify('???###')),
            'category_id' => Category::factory(),
            'brand_id' => Brand::factory(),
            'unit_id' => Unit::factory(),
            'cost_price' => $costPrice,
            'selling_price' => round($sellingPrice, -3), // Round to thousands
            'min_stock' => $this->faker->numberBetween(5, 20),
            'description' => $this->faker->optional()->sentence(),
        ];
    }
}
