<?php

namespace Database\Factories;

use App\Models\Unit;
use Illuminate\Database\Eloquent\Factories\Factory;

class UnitFactory extends Factory
{
    protected $model = Unit::class;

    public function definition(): array
    {
        $units = [
            ['name' => 'Piece', 'short_name' => 'pcs'],
            ['name' => 'Box', 'short_name' => 'box'],
            ['name' => 'Set', 'short_name' => 'set'],
            ['name' => 'Unit', 'short_name' => 'unit'],
        ];

        $unit = $this->faker->unique()->randomElement($units);

        return [
            'name' => $unit['name'],
            'short_name' => $unit['short_name'],
        ];
    }
}
