<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * FIX CRITICAL BUG #1: Add missing columns to orders tables
     */
    public function up(): void
    {
        // Fix sales_orders table
        Schema::table('sales_orders', function (Blueprint $table) {
            // Add payment_method column
            $table->enum('payment_method', ['cash', 'transfer', 'card'])
                  ->after('paid_amount')
                  ->default('cash');
            
            // Add indexes for performance
            $table->index('order_date');
            $table->index('status');
            $table->index('created_at');
        });

        // Fix purchase_orders table  
        Schema::table('purchase_orders', function (Blueprint $table) {
            // Add payment_method column
            $table->enum('payment_method', ['cash', 'transfer', 'card'])
                  ->after('paid_amount')
                  ->default('cash');
            
            // Add indexes for performance
            $table->index('order_date');
            $table->index('status');
            $table->index('created_at');
        });

        // Add indexes to customer_debts
        Schema::table('customer_debts', function (Blueprint $table) {
            $table->index('status');
            $table->index('due_date');
        });

        // Add indexes to supplier_debts
        Schema::table('supplier_debts', function (Blueprint $table) {
            $table->index('status');
            $table->index('due_date');
        });

        // Add indexes to products
        Schema::table('products', function (Blueprint $table) {
            $table->index('name');
            $table->index('cost_price');
            $table->index('selling_price');
        });

        // Add indexes to customers
        Schema::table('customers', function (Blueprint $table) {
            $table->index('phone');
            $table->index('email');
        });

        // Add indexes to suppliers
        Schema::table('suppliers', function (Blueprint $table) {
            $table->index('phone');
            $table->index('email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_orders', function (Blueprint $table) {
            $table->dropColumn('payment_method');
            $table->dropIndex(['order_date']);
            $table->dropIndex(['status']);
            $table->dropIndex(['created_at']);
        });

        Schema::table('purchase_orders', function (Blueprint $table) {
            $table->dropColumn('payment_method');
            $table->dropIndex(['order_date']);
            $table->dropIndex(['status']);
            $table->dropIndex(['created_at']);
        });

        Schema::table('customer_debts', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['due_date']);
        });

        Schema::table('supplier_debts', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['due_date']);
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropIndex(['name']);
            $table->dropIndex(['cost_price']);
            $table->dropIndex(['selling_price']);
        });

        Schema::table('customers', function (Blueprint $table) {
            $table->dropIndex(['phone']);
            $table->dropIndex(['email']);
        });

        Schema::table('suppliers', function (Blueprint $table) {
            $table->dropIndex(['phone']);
            $table->dropIndex(['email']);
        });
    }
};
