<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Warehouse;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Unit;
use App\Models\Product;
use App\Models\Customer;
use App\Models\Supplier;
use App\Models\Inventory;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create Users
        User::create([
            'name' => 'Admin',
            'email' => 'admin@trungduong.com',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        User::create([
            'name' => 'Nhân Viên',
            'email' => 'staff@trungduong.com',
            'password' => Hash::make('staff123'),
            'role' => 'staff',
            'is_active' => true,
        ]);

        // Create Warehouses
        $mainWarehouse = Warehouse::create([
            'name' => 'Kho Chính - 436B/65 Đường 3/2',
            'address' => '436B/65 Đường 3/2, Quận 10, TP.HCM',
            'phone' => '0976494949',
            'manager_id' => 1,
            'is_active' => true,
        ]);

        // Create Categories
        $categories = [
            ['name' => 'Pin iPhone', 'description' => 'Pin thay thế cho iPhone các dòng'],
            ['name' => 'Pin iPad', 'description' => 'Pin thay thế cho iPad các dòng'],
            ['name' => 'Linh kiện iPhone', 'description' => 'Linh kiện phụ tùng iPhone'],
            ['name' => 'Phụ kiện', 'description' => 'Phụ kiện điện thoại, sạc, cáp'],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }

        // Create Brands
        $brands = [
            ['name' => 'Apple', 'description' => 'Chính hãng Apple'],
            ['name' => 'Pisen', 'description' => 'Pin Pisen chất lượng cao'],
            ['name' => 'Baseus', 'description' => 'Phụ kiện Baseus'],
            ['name' => 'Anker', 'description' => 'Sạc và phụ kiện Anker'],
        ];

        foreach ($brands as $brand) {
            Brand::create($brand);
        }

        // Create Units
        $units = [
            ['name' => 'Cái', 'short_name' => 'cái'],
            ['name' => 'Bộ', 'short_name' => 'bộ'],
            ['name' => 'Hộp', 'short_name' => 'hộp'],
        ];

        foreach ($units as $unit) {
            Unit::create($unit);
        }

        // Create Products
        $products = [
            [
                'name' => 'Pin iPhone 13 Pro Max',
                'sku' => 'PIN-IP13PM',
                'barcode' => '8934567890123',
                'category_id' => 1,
                'brand_id' => 2,
                'unit_id' => 1,
                'description' => 'Pin dung lượng cao cho iPhone 13 Pro Max',
                'purchase_price' => 450000,
                'selling_price' => 650000,
                'min_stock' => 5,
                'is_active' => true,
            ],
            [
                'name' => 'Pin iPhone 12 Pro',
                'sku' => 'PIN-IP12P',
                'barcode' => '8934567890124',
                'category_id' => 1,
                'brand_id' => 2,
                'unit_id' => 1,
                'description' => 'Pin chính hãng cho iPhone 12 Pro',
                'purchase_price' => 400000,
                'selling_price' => 580000,
                'min_stock' => 5,
                'is_active' => true,
            ],
            [
                'name' => 'Pin iPhone 11',
                'sku' => 'PIN-IP11',
                'barcode' => '8934567890125',
                'category_id' => 1,
                'brand_id' => 2,
                'unit_id' => 1,
                'description' => 'Pin iPhone 11 dung lượng chuẩn',
                'purchase_price' => 350000,
                'selling_price' => 500000,
                'min_stock' => 10,
                'is_active' => true,
            ],
            [
                'name' => 'Pin iPad Pro 12.9',
                'sku' => 'PIN-IPADP129',
                'barcode' => '8934567890126',
                'category_id' => 2,
                'brand_id' => 2,
                'unit_id' => 1,
                'description' => 'Pin dung lượng cao cho iPad Pro 12.9 inch',
                'purchase_price' => 800000,
                'selling_price' => 1200000,
                'min_stock' => 3,
                'is_active' => true,
            ],
            [
                'name' => 'Cáp Sạc Type-C Lightning',
                'sku' => 'CAP-TC-LT',
                'barcode' => '8934567890127',
                'category_id' => 4,
                'brand_id' => 3,
                'unit_id' => 1,
                'description' => 'Cáp sạc nhanh Type-C to Lightning',
                'purchase_price' => 80000,
                'selling_price' => 150000,
                'min_stock' => 20,
                'is_active' => true,
            ],
            [
                'name' => 'Sạc Nhanh 20W USB-C',
                'sku' => 'SAC-20W-USBC',
                'barcode' => '8934567890128',
                'category_id' => 4,
                'brand_id' => 4,
                'unit_id' => 1,
                'description' => 'Adapter sạc nhanh 20W cổng USB-C',
                'purchase_price' => 150000,
                'selling_price' => 250000,
                'min_stock' => 15,
                'is_active' => true,
            ],
        ];

        foreach ($products as $product) {
            Product::create($product);
        }

        // Create Inventory for each product
        for ($i = 1; $i <= 6; $i++) {
            Inventory::create([
                'warehouse_id' => $mainWarehouse->id,
                'product_id' => $i,
                'quantity' => rand(10, 50),
            ]);
        }

        // Create Customers
        $customers = [
            [
                'name' => 'Nguyễn Văn A',
                'phone' => '0901234567',
                'email' => 'nguyenvana@gmail.com',
                'address' => '123 Lê Văn Sỹ, Q.3, TP.HCM',
                'is_active' => true,
            ],
            [
                'name' => 'Trần Thị B',
                'phone' => '0912345678',
                'email' => 'tranthib@gmail.com',
                'address' => '456 Nguyễn Trãi, Q.5, TP.HCM',
                'is_active' => true,
            ],
            [
                'name' => 'Lê Văn C',
                'phone' => '0923456789',
                'email' => 'levanc@gmail.com',
                'address' => '789 Cách Mạng Tháng 8, Q.10, TP.HCM',
                'is_active' => true,
            ],
        ];

        foreach ($customers as $customer) {
            Customer::create($customer);
        }

        // Create Suppliers
        $suppliers = [
            [
                'name' => 'Công Ty Pin Việt Nam',
                'phone' => '0283456789',
                'email' => 'pinvn@company.com',
                'address' => '100 Hoàng Văn Thụ, Q.Tân Bình, TP.HCM',
                'is_active' => true,
            ],
            [
                'name' => 'Nhà Phân Phối Phụ Kiện Apple',
                'phone' => '0287654321',
                'email' => 'apple@distributor.com',
                'address' => '200 Điện Biên Phủ, Q.Bình Thạnh, TP.HCM',
                'is_active' => true,
            ],
        ];

        foreach ($suppliers as $supplier) {
            Supplier::create($supplier);
        }

        $this->command->info('✅ Seeding completed successfully!');
    }
}
