<?php
/**
 * TrungDuongService v3.0 - Web Installer
 * Truy cập: yourdomain.com/install.php
 */

// Prevent running if already installed
if (file_exists('../.env') && filesize('../.env') > 100) {
    die('
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Đã Cài Đặt</title>
        <style>
            body { font-family: Arial; background: #f5f6fa; padding: 50px; text-align: center; }
            .box { background: white; padding: 40px; border-radius: 10px; max-width: 500px; margin: 0 auto; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            h1 { color: #667eea; }
            .btn { background: #667eea; color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; display: inline-block; margin-top: 20px; }
        </style>
    </head>
    <body>
        <div class="box">
            <h1>✅ Hệ Thống Đã Được Cài Đặt</h1>
            <p>Hệ thống TrungDuongService đã được cài đặt thành công.</p>
            <a href="login.html" class="btn">🔑 Đăng Nhập Ngay</a>
            <br><br>
            <small style="color: #999;">Xóa file install.php để bảo mật</small>
        </div>
    </body>
    </html>
    ');
}

// Initialize
$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$errors = [];
$success = [];

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['check_requirements'])) {
        $step = 2;
    } elseif (isset($_POST['save_database'])) {
        $db_host = $_POST['db_host'];
        $db_port = $_POST['db_port'];
        $db_name = $_POST['db_name'];
        $db_user = $_POST['db_user'];
        $db_pass = $_POST['db_pass'];
        $app_url = $_POST['app_url'];
        
        // Test database connection
        try {
            $dsn = "mysql:host=$db_host;port=$db_port;dbname=$db_name";
            $pdo = new PDO($dsn, $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Create .env file
            $env_content = "APP_NAME=\"TrungDuongService\"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=$app_url

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=error

DB_CONNECTION=mysql
DB_HOST=$db_host
DB_PORT=$db_port
DB_DATABASE=$db_name
DB_USERNAME=$db_user
DB_PASSWORD=$db_pass

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

SANCTUM_STATEFUL_DOMAINS=$app_url
";
            
            file_put_contents('../.env', $env_content);
            chmod('../.env', 0644);
            
            $success[] = 'Kết nối database thành công!';
            $success[] = 'File .env đã được tạo!';
            $step = 3;
        } catch (PDOException $e) {
            $errors[] = 'Lỗi kết nối database: ' . $e->getMessage();
            $step = 2;
        }
    } elseif (isset($_POST['run_installation'])) {
        $output = [];
        
        // Run composer install
        exec('cd .. && composer install --no-dev --optimize-autoloader 2>&1', $output);
        
        // Generate app key
        exec('cd .. && php artisan key:generate --force 2>&1', $output);
        
        // Run migrations
        exec('cd .. && php artisan migrate --force 2>&1', $output);
        
        // Run seeder
        exec('cd .. && php artisan db:seed --force 2>&1', $output);
        
        // Set permissions
        @chmod('../storage', 0775);
        @chmod('../bootstrap/cache', 0775);
        exec('cd .. && chmod -R 775 storage bootstrap/cache 2>&1', $output);
        
        $success[] = 'Cài đặt thành công!';
        $step = 4;
    }
}

// Check requirements
function checkRequirements() {
    $requirements = [
        'PHP >= 8.2' => version_compare(PHP_VERSION, '8.2.0', '>='),
        'BCMath Extension' => extension_loaded('bcmath'),
        'Ctype Extension' => extension_loaded('ctype'),
        'Fileinfo Extension' => extension_loaded('fileinfo'),
        'JSON Extension' => extension_loaded('json'),
        'Mbstring Extension' => extension_loaded('mbstring'),
        'OpenSSL Extension' => extension_loaded('openssl'),
        'PDO Extension' => extension_loaded('pdo'),
        'PDO MySQL Extension' => extension_loaded('pdo_mysql'),
        'Tokenizer Extension' => extension_loaded('tokenizer'),
        'XML Extension' => extension_loaded('xml'),
        'Storage Writable' => is_writable('../storage'),
        'Bootstrap Cache Writable' => is_writable('../bootstrap/cache'),
        'Composer Installed' => file_exists('../vendor/autoload.php')
    ];
    
    return $requirements;
}

?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cài Đặt TrungDuongService v3.0</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        .content {
            padding: 40px;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e0e0e0;
        }
        .step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        .step.active {
            color: #667eea;
            font-weight: bold;
        }
        .step.completed {
            color: #28a745;
        }
        .form-group {
            margin-bottom: 25px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        .form-group input, .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
        }
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        .btn {
            padding: 14px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
            width: 100%;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .requirements-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .requirements-table th,
        .requirements-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }
        .requirements-table th {
            background: #f8f9fa;
            font-weight: 600;
        }
        .status-pass {
            color: #28a745;
            font-weight: bold;
        }
        .status-fail {
            color: #dc3545;
            font-weight: bold;
        }
        .info-box {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .success-icon {
            font-size: 80px;
            text-align: center;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔧 TrungDuongService v3.0</h1>
            <p>Hệ Thống Quản Lý Bán Hàng & Công Nợ</p>
            <p style="margin-top: 10px; font-size: 14px;">📞 0976494949 | 083 7555 5000</p>
        </div>

        <div class="content">
            <div class="step-indicator">
                <div class="step <?php echo $step >= 1 ? 'active' : ''; ?> <?php echo $step > 1 ? 'completed' : ''; ?>">
                    <div>1. Chào Mừng</div>
                </div>
                <div class="step <?php echo $step >= 2 ? 'active' : ''; ?> <?php echo $step > 2 ? 'completed' : ''; ?>">
                    <div>2. Kiểm Tra</div>
                </div>
                <div class="step <?php echo $step >= 3 ? 'active' : ''; ?> <?php echo $step > 3 ? 'completed' : ''; ?>">
                    <div>3. Cấu Hình</div>
                </div>
                <div class="step <?php echo $step >= 4 ? 'active' : ''; ?>">
                    <div>4. Hoàn Tất</div>
                </div>
            </div>

            <?php if (!empty($errors)): ?>
                <div class="alert alert-danger">
                    <?php foreach ($errors as $error): ?>
                        ❌ <?php echo htmlspecialchars($error); ?><br>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($success)): ?>
                <div class="alert alert-success">
                    <?php foreach ($success as $msg): ?>
                        ✅ <?php echo htmlspecialchars($msg); ?><br>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if ($step === 1): ?>
                <h2>👋 Chào Mừng Đến Với TrungDuongService!</h2>
                <p style="margin: 20px 0;">Trình cài đặt này sẽ giúp bạn thiết lập hệ thống quản lý bán hàng và công nợ một cách dễ dàng.</p>
                
                <div class="info-box">
                    <strong>📋 Những gì bạn cần chuẩn bị:</strong>
                    <ul style="margin: 10px 0 0 20px;">
                        <li>Thông tin database (host, tên DB, username, password)</li>
                        <li>URL website của bạn</li>
                        <li>Khoảng 2-3 phút để hoàn tất</li>
                    </ul>
                </div>

                <form method="post" style="margin-top: 30px;">
                    <button type="submit" name="check_requirements" class="btn">
                        Bắt Đầu Cài Đặt →
                    </button>
                </form>

            <?php elseif ($step === 2): ?>
                <h2>🔍 Kiểm Tra Yêu Cầu Hệ Thống</h2>
                
                <?php
                $requirements = checkRequirements();
                $all_passed = !in_array(false, $requirements);
                ?>

                <table class="requirements-table">
                    <thead>
                        <tr>
                            <th>Yêu Cầu</th>
                            <th>Trạng Thái</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($requirements as $name => $status): ?>
                        <tr>
                            <td><?php echo $name; ?></td>
                            <td class="<?php echo $status ? 'status-pass' : 'status-fail'; ?>">
                                <?php echo $status ? '✅ Đạt' : '❌ Không đạt'; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <?php if (!$all_passed): ?>
                    <div class="alert alert-danger">
                        ⚠️ Một số yêu cầu chưa đáp ứng. Vui lòng khắc phục trước khi tiếp tục.
                    </div>
                <?php else: ?>
                    <div class="alert alert-success">
                        ✅ Tất cả yêu cầu đã đạt! Bạn có thể tiếp tục.
                    </div>
                    
                    <form method="get" style="margin-top: 30px;">
                        <input type="hidden" name="step" value="2">
                        <button type="submit" class="btn" <?php echo !$all_passed ? 'disabled' : ''; ?>>
                            Tiếp Theo: Cấu Hình Database →
                        </button>
                    </form>
                <?php endif; ?>

            <?php elseif ($step === 2 && isset($_GET['step']) && $_GET['step'] == 2): ?>
                <h2>⚙️ Cấu Hình Database</h2>
                <p style="margin-bottom: 20px;">Nhập thông tin database của bạn:</p>

                <form method="post">
                    <div class="form-group">
                        <label>Database Host *</label>
                        <input type="text" name="db_host" value="localhost" required>
                    </div>

                    <div class="form-group">
                        <label>Database Port *</label>
                        <input type="text" name="db_port" value="3306" required>
                    </div>

                    <div class="form-group">
                        <label>Database Name *</label>
                        <input type="text" name="db_name" placeholder="trungduong_v3" required>
                    </div>

                    <div class="form-group">
                        <label>Database Username *</label>
                        <input type="text" name="db_user" placeholder="root" required>
                    </div>

                    <div class="form-group">
                        <label>Database Password</label>
                        <input type="password" name="db_pass" placeholder="Để trống nếu không có password">
                    </div>

                    <div class="form-group">
                        <label>URL Website *</label>
                        <input type="url" name="app_url" value="<?php echo 'http://' . $_SERVER['HTTP_HOST']; ?>" required>
                        <small style="color: #666;">Ví dụ: https://trungduongservice.com</small>
                    </div>

                    <button type="submit" name="save_database" class="btn">
                        Lưu & Kiểm Tra Kết Nối →
                    </button>
                </form>

            <?php elseif ($step === 3): ?>
                <h2>🚀 Cài Đặt Hệ Thống</h2>
                <p style="margin-bottom: 20px;">Bước cuối cùng! Nhấn nút bên dưới để cài đặt hệ thống.</p>

                <div class="info-box">
                    <strong>⚠️ Lưu ý:</strong>
                    <ul style="margin: 10px 0 0 20px;">
                        <li>Quá trình có thể mất 1-2 phút</li>
                        <li>Không tắt trình duyệt trong quá trình cài đặt</li>
                        <li>Hệ thống sẽ tự động tạo tài khoản admin</li>
                    </ul>
                </div>

                <form method="post" style="margin-top: 30px;">
                    <button type="submit" name="run_installation" class="btn">
                        ⚡ Bắt Đầu Cài Đặt
                    </button>
                </form>

            <?php elseif ($step === 4): ?>
                <div class="success-icon">🎉</div>
                <h2 style="text-align: center; color: #28a745;">Cài Đặt Thành Công!</h2>
                
                <div class="alert alert-success" style="margin: 30px 0;">
                    <strong>✅ Hệ thống đã được cài đặt hoàn tất!</strong><br>
                    Bạn có thể bắt đầu sử dụng ngay bây giờ.
                </div>

                <div class="info-box">
                    <strong>👤 Tài Khoản Admin Mặc Định:</strong><br>
                    <strong>Email:</strong> admin@trungduong.com<br>
                    <strong>Password:</strong> admin123<br><br>
                    
                    <strong>👥 Tài Khoản Staff Demo:</strong><br>
                    <strong>Email:</strong> staff@trungduong.com<br>
                    <strong>Password:</strong> staff123
                </div>

                <div class="alert alert-danger" style="margin-top: 20px;">
                    <strong>🔒 Quan Trọng - Bảo Mật:</strong>
                    <ul style="margin: 10px 0 0 20px;">
                        <li>Xóa file <code>install.php</code> ngay lập tức</li>
                        <li>Đổi mật khẩu admin sau khi đăng nhập</li>
                        <li>Set <code>APP_DEBUG=false</code> trong file .env</li>
                    </ul>
                </div>

                <div style="margin-top: 30px; text-align: center;">
                    <a href="login.html" class="btn" style="display: inline-block; text-decoration: none;">
                        🔑 Đăng Nhập Ngay
                    </a>
                </div>

                <p style="text-align: center; margin-top: 20px; color: #999; font-size: 14px;">
                    📞 Hỗ trợ: 0976494949 | 083 7555 5000<br>
                    📧 Email: support@trungduongservice.com
                </p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
