<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\BrandController;
use App\Http\Controllers\Api\UnitController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\SupplierController;
use App\Http\Controllers\Api\SalesOrderController;
use App\Http\Controllers\Api\PurchaseOrderController;
use App\Http\Controllers\Api\DebtController;
use App\Http\Controllers\Api\ReportController;
use App\Http\Controllers\Api\WarehouseController;

// Public routes
Route::post('/login', [AuthController::class, 'login']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // Auth
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/me', [AuthController::class, 'me']);

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index']);

    // Products
    Route::apiResource('products', ProductController::class);
    Route::post('/products/search-barcode', [ProductController::class, 'searchByBarcode']);
    Route::get('/products-low-stock', [ProductController::class, 'lowStock']);

    // Categories
    Route::apiResource('categories', CategoryController::class);

    // Brands
    Route::apiResource('brands', BrandController::class);

    // Units
    Route::apiResource('units', UnitController::class);

    // Customers
    Route::apiResource('customers', CustomerController::class);
    Route::get('/customers/{id}/debts', [CustomerController::class, 'debts']);

    // Suppliers
    Route::apiResource('suppliers', SupplierController::class);
    Route::get('/suppliers/{id}/debts', [SupplierController::class, 'debts']);

    // Sales Orders
    Route::apiResource('sales-orders', SalesOrderController::class)->except(['update', 'destroy']);
    Route::post('/sales-orders/{id}/cancel', [SalesOrderController::class, 'cancel']);

    // Purchase Orders
    Route::apiResource('purchase-orders', PurchaseOrderController::class)->except(['update', 'destroy']);
    Route::post('/purchase-orders/{id}/cancel', [PurchaseOrderController::class, 'cancel']);

    // Debts
    Route::get('/debts/customer', [DebtController::class, 'customerDebts']);
    Route::get('/debts/supplier', [DebtController::class, 'supplierDebts']);
    Route::get('/debts/summary', [DebtController::class, 'summary']);
    Route::post('/debts/customer/{id}/pay', [DebtController::class, 'payCustomerDebt']);
    Route::post('/debts/supplier/{id}/pay', [DebtController::class, 'paySupplierDebt']);

    // Reports
    Route::get('/reports/revenue', [ReportController::class, 'revenue']);
    Route::get('/reports/inventory', [ReportController::class, 'inventory']);
    Route::get('/reports/debts', [ReportController::class, 'debts']);
    Route::get('/reports/profit', [ReportController::class, 'profit']);

    // Warehouses
    Route::apiResource('warehouses', WarehouseController::class);
});
